#ifndef _RFS_XATTR_H
#define _RFS_XATTR_H

#include <linux/version.h>

#if (LINUX_VERSION_CODE >= KERNEL_VERSION(4,9,0))
#include <linux/xattr.h>
#include <linux/list.h>

// One unique entry for each mounted file system
// saves original xattr_handler** from its super_block.
struct rfs_xattr_entry {
	struct list_head list;
	const struct xattr_handler **handlers;
	dev_t dev;
};

struct rfs_xattr_entry *rfs_xattr_find(const dev_t dev);
struct rfs_xattr_entry *rfs_xattr_add(const dev_t dev, const struct xattr_handler **handlers);

#endif
#endif
