#include "rfs_xattr.h"
#include "rfs.h"

#if (LINUX_VERSION_CODE >= KERNEL_VERSION(4,9,0))
LIST_HEAD(pool);

struct rfs_xattr_entry *rfs_xattr_entry_alloc(const dev_t dev, const struct xattr_handler **handlers)
{
		struct rfs_xattr_entry *entry = NULL;

		entry = kzalloc(sizeof(struct rfs_xattr_entry), GFP_KERNEL);
		if (!entry)
			return ERR_PTR(-ENOMEM);

		INIT_LIST_HEAD(&entry->list);
		entry->dev = dev;
		entry->handlers = handlers;
		list_add_tail(&entry->list, &pool);

		return entry;
}

struct rfs_xattr_entry *rfs_xattr_find(const dev_t dev)
{
	struct rfs_xattr_entry *pos = NULL;
	struct rfs_xattr_entry *found = NULL;

	list_for_each_entry(pos, &pool, list) {
		if (pos->dev != dev)
			continue;

		found = pos;
		break;
	}

	return found;
}

struct rfs_xattr_entry *rfs_xattr_add(const dev_t dev, const struct xattr_handler **handlers)
{
	struct rfs_xattr_entry *entry = NULL;

	entry = rfs_xattr_find(dev);
	if (entry)
		return entry;

	return rfs_xattr_entry_alloc(dev, handlers);
}

#endif
