#include "hnfsflt.h"

int __init hnfsflt_init(void)
{
	int ret;

	ret = hnfsflt_data_init();
	if (ret) {
		printk(KERN_ALERT "hnfsflt: initializing data structures failed (%d)\n", ret);
		return ret;
	}

	ret = hnfsflt_dev_init();
	if (ret) {
		printk(KERN_ALERT "hnfsflt: registering char device failed (%d)\n", ret);
		goto fail_dev;
	}

	ret = hnfsflt_rfs_init();
	if (ret) {
		printk(KERN_ALERT "hnfsflt: initializing rfs filter failed (%d)\n", ret);
		goto fail_rfs;
	}

	ret = hnfsflt_sys_init();
	if (ret) {
		printk(KERN_ALERT "hnfsflt: registering sysfs attribute failed (%d)\n", ret);
		goto fail_sys;
	}

	printk(KERN_INFO "hnfsflt: redirfs filter initialized. Version is " HNFSFLT_VERSION ".\n");

	return 0;

fail_sys:
	redirfs_unregister_filter(hnfsflt);
	hnfsflt_rfs_cleanup();
fail_rfs:
	hnfsflt_dev_cleanup();
fail_dev:
	hnfsflt_data_cleanup();
	return ret;
}


/*
 * Module unload. Kernel checks if ref counter is zero.
 */
void __exit hnfsflt_exit(void)
{
	hnfsflt_sys_cleanup();
	hnfsflt_rfs_cleanup();
	hnfsflt_dev_cleanup();
	hnfsflt_data_cleanup();

	printk(KERN_INFO "hnfsflt: unloaded\n");
}

module_init(hnfsflt_init);
module_exit(hnfsflt_exit);

MODULE_LICENSE("Dual BSD/GPL");
MODULE_AUTHOR("Jakob Blomer <jakob.blomer@cern.ch>");
MODULE_AUTHOR("Atempo SA <contact@atempo.com>");
MODULE_DESCRIPTION("A filter for redirfs that logs changes to a directory tree. Version is " HNFSFLT_VERSION ".");
MODULE_SUPPORTED_DEVICE("hnfs");	/* This module uses /dev/hnfs. */
